<?php 
/**
 * Template Name: Service Template
 *
 * 
 */
?>

<?php get_header(); ?>

	<?php do_action( 'accelerate_before_body_content' ); ?>
<div class="clearfix">
	<div id="primary">
		<div id="content" class="clearfix">
			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'content', 'page' ); ?>

				<?php
					do_action( 'accelerate_before_comments_template' );
					// If comments are open or we have at least one comment, load up the comment template
					if ( comments_open() || '0' != get_comments_number() )
						comments_template();					
	      		do_action ( 'accelerate_after_comments_template' );
				?>

			<?php endwhile; ?>

		</div><!-- #content -->
	</div><!-- #primary -->
	
	<?php accelerate_sidebar_select(); ?>



	<?php do_action( 'accelerate_after_body_content' ); ?>
</div>

<div class="sequela-team clearfix">
<h3>Our Therapists And Advisors</h3>
	<?php
	$query = new WP_Query(array(
		'post_type' => 'our-team', 
		'category_name' => 'our-therapists-and-advisors',
		'order' => 'ASC'));
	while($query->have_posts()):$query->the_post();
	?>
	<div class="team">
		<div class="wrap-img">
			<?php the_post_thumbnail(); ?>

		</div>
		<h4><?php the_title(); ?></h4>
		<?php the_excerpt(); ?>
	</div>

	<?php 
	endwhile; wp_reset_query(); ?>
</div>

<div class="activities clearfix">
<?php
$query = new WP_Query(array('post_type' => 'projects', 'order'=>"ASC"));
while($query->have_posts()):$query->the_post();
?>
<div class="activity">
<div class="activity_img">
	<?php the_post_thumbnail(); ?>
</div>
<div class="activity_text">
	<h4><?php the_title(); ?></h4>
	<?php the_excerpt(); ?>
</div>
</div>
<?php 
endwhile; wp_reset_query();
 ?>
</div>

<?php get_footer(); ?>