<?php 
/**
 * Template Name: Project Template
 *
 *
 *
 * 
 */
global $post;
?>

<?php get_header(); ?>
<?php do_action( 'accelerate_before_body_content' ); ?>

<div id="primary">
	<div id="content" class="clearfix">
		
		<div class="article-wrap">

			<?php $query = new WP_Query(array('post_type' => 'activities'));
			while($query->have_posts()): $query->the_post();
			$thumb_id= get_post_thumbnail_id(get_the_ID());
			$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
			$img=wp_get_attachment_image_src($thumb_id,'large' );
			?>
			<article class="post-115 projects type-projects status-publish has-post-thumbnail hentry">

				<header class="entry-header">
					<h2 class="entry-title">
						<a title="<?php the_title();?>" href="javascript:void(0);"><?php the_title();?></a>
					</h2>
				</header>


				<figure class="post-featured-image">
					<img src="<?php echo get_template_directory_uri(); ?>/thumb.php?src=<?php echo $img[0]; ?>&h=170w=300&zc=1" alt="<?php echo !empty($alt) ? __($alt,'gandaki') : get_the_title(); ?>">
				</figure>
				<div class="entry-content clearfix">
					<?php the_excerpt();?>
				</div>

			</article>


			<?php
			endwhile; wp_reset_query();
			?>
		</div>
		<!-- article-wraPE ENDS HERE -->
		

		
		<div class="col-about date-fix">
			<div class="box3-text">
				
				<?php echo apply_filters("the_content",$post->post_content); ?>
			</div>
		</div>



	</div><!-- #content -->
</div><!-- #primary -->

<?php accelerate_sidebar_select(); ?>

<?php do_action( 'accelerate_after_body_content' ); ?>

<?php get_footer(); ?>