<?php
/**
* Template Name: Newsletter Template
*
*/
?>
<?php get_header(); ?>
<?php do_action( 'accelerate_before_body_content' ); ?>
<div id="primary">
	<div id="content" class="clearfix">
	<h1 class="entry-title"><?php echo $post->post_title; ?></h1>
		<div class="nesletter-wrap">
			<?php $query = new WP_Query(array('post_type' => 'newsletter'));
			while($query->have_posts()): $query->the_post();
			$pdf = get_post_meta( get_the_ID(), 'pdf', true );
			$pdfUrl = wp_get_attachment_url($pdf);
			 
			?>
			<article class="newsletter-box">
				
				<div class="docs">
				<a title="<?php the_title();?>" href="<?php echo $pdfUrl; ?> ">
						<img src="<?php echo get_template_directory_uri(); ?>/images/pdf.png" alt="" style="width:50px; height:auto; float:left; margin-right:5px;margin-bottom:10px;">
					</a>
					<h2><a title="<?php the_title();?>" href="<?php echo $pdfUrl; ?> "><?php the_title();?></a></h2>
				<div class="clearfix"></div>
					<?php the_content();?>
				</div>
			</article>
			<?php
			endwhile; wp_reset_query;
			?>
		</div>
	</div><!-- #content -->
</div><!-- #primary -->

		<?php accelerate_sidebar_select(); ?>
		
		<?php do_action( 'accelerate_after_body_content' ); ?>
		<?php get_footer(); ?>