<?php 
/**
 * Template Name: About Template
 * 
 */
?>

<?php get_header(); ?>

<?php do_action( 'accelerate_before_body_content' ); ?>
<div class="clearfix">
	<div id="primary">
		<div id="content " class="col-about-left officer-fix clearfix">
			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'content', 'page' ); ?>

				<?php
				do_action( 'accelerate_before_comments_template' );
					// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || '0' != get_comments_number() )
					comments_template();					
				do_action ( 'accelerate_after_comments_template' );
				?>

			<?php endwhile; ?>
			<?php
			$query = new WP_Query(array('p' => 155));
			while($query->have_posts()):$query->the_post();
			?>
			<div class="col-full-about">
				<div class="box3-text">
					<h4><?php the_title(); ?></h4>
					<?php the_content(); ?>
				</div>
			</div>
			<?php 
			endwhile; wp_reset_query();
			?>

		</div><!-- #content -->

		<?php
		$query = new WP_Query(array('p' => 73));
		while($query->have_posts()):$query->the_post();
		?>
		<div class="col-about">
			<div class="box-text">
				<h4><?php the_title(); ?></h4>
				<?php the_content(); ?>
			</div>
		</div>
		<?php 
		endwhile; wp_reset_query();
		?>

		

	</div><!-- #primary -->
	
	<?php accelerate_sidebar_select(); ?>



	<?php do_action( 'accelerate_after_body_content' ); ?>
</div>
<div class="sequela-team clearfix">
	<h3>The Trustees</h3>
	<?php
	$query = new WP_Query(array(
		'post_type' => 'our-team', 
		'category_name' => 'the-trustees',
		'order' => 'ASC'));
	while($query->have_posts()):$query->the_post();
	$thumb_id= get_post_thumbnail_id(get_the_ID());
	$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
	$img=wp_get_attachment_image_src($thumb_id,'large' );
	?>
	<div class="team">
		<div class="wrap-img">
			<img src="<?php echo get_template_directory_uri(); ?>/thumb.php?src=<?php echo $img[0]; ?>&h=150w=220&zc=1" alt="<?php echo get_the_title(); ?>">

		</div>
		<h4><?php the_title(); ?></h4>
		<?php the_excerpt(); ?>
	</div>

	<?php 
	endwhile; wp_reset_query(); ?>
</div>

<div class="sequela-team clearfix">
	<h3>The Committee and Associates</h3>
	<?php
	$query = new WP_Query(array(
		'post_type' => 'our-team', 
		'category_name' => 'the-committee',
		'order' => 'ASC'));
	while($query->have_posts()):$query->the_post();
	$thumb_id= get_post_thumbnail_id(get_the_ID());
	$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
	$img=wp_get_attachment_image_src($thumb_id,'large' );
	?>
	<div class="team">
		<div class="wrap-img">
			<img src="<?php echo get_template_directory_uri(); ?>/thumb.php?src=<?php echo $img[0]; ?>&h=194w=220&zc=1" alt="<?php echo get_the_title(); ?>">

		</div>
		<h4><?php the_title(); ?></h4>
		<?php the_excerpt(); ?>
	</div>

	<?php 
	endwhile; wp_reset_query(); ?>
</div>

<?php /* <div class="sequela-team clearfix">
<h3>Our Therapists And Advisors</h3>
	<?php
	$query = new WP_Query(array(
		'post_type' => 'our-team', 
		'category_name' => 'our-therapists-and-advisors',
		'order' => 'ASC'));
	while($query->have_posts()):$query->the_post();
	?>
	<div class="team">
		<div class="wrap-img">
			<?php the_post_thumbnail(); ?>

		</div>
		<h4><?php the_title(); ?></h4>
		<?php the_excerpt(); ?>
	</div>

	<?php 
	endwhile; wp_reset_query(); ?>
</div> */ ?>

<?php get_footer(); ?>
